<!doctype html>
<html lang="en">
<head>
<!-- Required meta tags -->
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<!-- Bootstrap CSS -->
<link rel="stylesheet" href="/sites/all/themes/rollontires/css/bootstrap.min.css">
<!-- Slick Slider CSS -->
<link rel="stylesheet" href="/sites/all/themes/rollontires/css/slick.min.css"/>
<link rel="stylesheet" href="/sites/all/themes/rollontires/css/slick-theme.min.css"/>
<!-- Font Awesome CSS -->
<link rel="stylesheet" href="/sites/all/themes/rollontires/css/font-awesome.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="/sites/all/themes/rollontires/css/style.css">
<link rel="icon" type="image/png" href="/favicon.png">
<title><?php print $head_title; ?></title>
<?php print $head; ?>
<?php print $styles; ?>
<?php print $scripts; ?>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-157890055-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-157890055-1');
</script>

</head>
<body class="<?php print date('l').' '; print $classes; ?>" <?php print $attributes;?>>
<?php print $page_top; ?>

<header class="header position-relative">
<div id="top-top">
		<p>
			<?php global $user;
        if (!user_is_logged_in()){ ?>
        	<a href="/user/register/">Already a Member?</a>
        	<?php } ?>
    	</p>
			<div class="user-details">
        <?php global $user;
        if (user_is_logged_in()){ ?>
	        Logged in as: <?php 
	        //echo print_r($user->roles);
	        $roles = implode(', ', $user->roles);
	        $roles = str_replace('authenticated user,', '', $roles);
	        echo $roles; 
    	}
        ?></div>
         

</div>
<div class="container d-flex align-items-center">

	<h1 class="logo col p-0">
		<a href="/" class="d-inline-block">
			<img src="/sites/all/themes/rollontires/images/longshot-logo-header.png" alt="" class="d-block" >
		</a>
	</h1>
	<p class="primary-font"></p>

<!--<?php print render($main_menu); ?>-->


<?php


// Load the currently logged in user.
global $user;

// Check if the user has the 'editor' role, when 'editor' has role
if (array_key_exists(6, $user->roles)) {
  // do fancy stuff
}

$menu_rendered = false;

?>


<nav class="menu d-md-flex align-items-center">
<ul class="clearfix">
	<?php if(!user_is_logged_in()){ ?>
		<li><a href="/">Home</a></li>    
		<li><a href="/#about">About</a></li>   
		<li><a href="/#screenshots">Winnings</a></li>    
		<!--<li><a href="/#pricing">Pricing</a></li>-->
		<li><a href="/#contact">Contact Us</a></li> 
		<li><a href="/faq">FAQ</a></li>
		<li><a href="/user">Login</a></li>
		<li><a href="/user/register">Register</a></li>    
	<? } else { ?>
		<?php 
		// Free Subscription
		if (array_key_exists(6, $user->roles) && ($menu_rendered == false)) { 
			$menu_rendered = true;
			?>
			<li><a class="purchase-daily" href="/purchase-daily-pick">Purchase Daily Pick</a></li>
			<li><a class="upgrade" href="/upgrade">Upgrade</a></li>
			<li><a href="/faq">FAQ</a></li>
			<li><a href="/user">My Account</a></li>
			<li><a href="/user/logout">Logout</a></li>
			<li><a href="/cart">Cart</a></li>
		<?php } ?>
		<?php 
		// Premium
		if (array_key_exists(8, $user->roles) && ($menu_rendered == false)) { 
			$menu_rendered = true;
			?>
			<li><a class="purchase-daily" href="/purchase-daily-pick">Purchase Daily Pick</a></li>
			<li><a class="upgrade" href="/upgrade">Upgrade</a></li>
			<li><a href="/user/<?php echo $user->uid; ?>/weekly-reports">Weekly</a></li>
			<li><a href="/faq">FAQ</a></li>
			<li><a href="/user">My Account</a></li>
			<li><a href="/user/logout">Logout</a></li>
		<?php } ?>
		<?php 
		// Ultra Premium
		if (array_key_exists(7, $user->roles) && ($menu_rendered == false)) { 
			$menu_rendered = true;
			?>
			<li><a href="/daily-pick">Daily Pick</a></li>
			<li><a href="/user/<?php echo $user->uid; ?>/weekly-reports">Weekly Reports</a></li>
			<li><a href="/faq">FAQ</a></li>
			<li><a href="/user">My Account</a></li>
			<li><a href="/user/logout">Logout</a></li>
		<?php } ?>
		<?php 
		// Admin
		if (array_key_exists(5, $user->roles) && ($menu_rendered == false)) { 
			$menu_rendered = true;
			?>
			<li><a href="/admin/commerce/orders">Orders</a></li>
			<li><a href="/admin/people">Subscribers</a></li>
			<li><a href="/admin/reports/membership-report">Reports</a></li>
			<li><a href="/faq">FAQ</a></li>
			<li><a href="/user">My Account</a></li>
			<li><a href="/user/logout">Logout</a></li>
		<?php } ?>
		<?php 
		// Authenticated User Only
		if (array_key_exists(2, $user->roles) && ($menu_rendered == false)) { 
			$menu_rendered = true;
			?>
			<li><a class="purchase-daily" href="/purchase-daily-pick">Purchase Daily Pick</a></li>
			<li><a class="upgrade" href="/upgrade">Upgrade</a></li>
			<li><a href="/faq">FAQ</a></li>
			<li><a href="/user">My Account</a></li>
			<li><a href="/user/logout">Logout</a></li>
			<li><a href="/cart">Cart</a></li>
		<?php } ?>
	<?php } ?>
</ul>
<div class="social-icons clearfix">
<!--<a target="_blank" href="https://www.facebook.com/The-Longshot-Report-105619084242402"><i class="fa fa-facebook-square"></i></a>
-->
<!--<a target="_blank" href="https://www.instagram.com/rollowaytires"><i class="fa fa-instagram"></i></a>
<a href="https://www.google.com/"><i class="fa fa-google-plus"></i></a>
<a target="_blank" href="https://www.twitter.com/"><i class="fa fa-twitter-square"></i></a>
<a href="https://www.youtube.com/"><i class="fa fa-youtube-play"></i></a>-->
</div>
</nav>
<div class="nav-icon d-flex align-items-center justify-content-center"><span class="col p-0"></span></div>
</div>
</header>


<?php print $page; ?>

<footer class="footer d-flex align-items-center">
<div class="container d-lg-flex align-items-center">
<div class="footer-columns footer-links">
<a href="/user">Login</a> | <!--<a href="/admin/dashboard">Admin</a> |--> <a href="/terms-and-conditions">Terms and Conditions</a> <!--| <a href="/refund-policy">Refund Policy </a>--> | <a href="/privacy-policy">Privacy Policy </a>
<br /><br />
<!--<img class="text-center" src="/sites/all/themes/rollontires/images/cc-logos.png" />-->
</div>
<div class="footer-columns col p-0 copyright text-center">
<p><!--If you have a gambling problem please call (800) 522-4700 |--> Copyright <?php echo date('Y'); ?> The Longshot Report</p>
</div>
<div class="footer-columns social-icons d-inline-flex clearfix">
<!--<a target="_blank" href="https://www.facebook.com/The-Longshot-Report-105619084242402"><i class="fa fa-facebook-square"></i></a>
-->
<!--<a target="_blank" shref="https://www.instagram.com/rollowaytires"><i class="fa fa-instagram"></i></a>
<a href="https://www.google.com/"><i class="fa fa-google-plus"></i></a>
<a target="_blank" href="https://www.twitter.com/"><i class="fa fa-twitter-square"></i></a>
<a href="https://www.youtube.com/"><i class="fa fa-youtube-play"></i></a>-->
</div>
</div>
</footer><!--//End Footer-->

<!-- jQuery JS -->
<script src="/sites/all/themes/rollontires/js/jquery-3.3.1.min.js"></script>
<!-- Bootstrap JS -->
<script src="/sites/all/themes/rollontires/js/popper.min.js"></script>
<script src="/sites/all/themes/rollontires/js/bootstrap.min.js"></script>
<!--Slick Slider JS-->
<script src="/sites/all/themes/rollontires/js/slick.min.js"></script>
<!-- Custom JS -->
<script src="/sites/all/themes/rollontires/js/custom.js"></script>
<?php print $page_bottom; ?>
</body>
</html>