<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * General utility variables:
 * - : The base URL path of the Drupal installation. At the very
 *   least, this will always default to /.
 * - : The directory the template is located in, e.g. modules/system
 *   or themes/bartik.
 * - : TRUE if the current page is the front page.
 * - : TRUE if the user is registered and signed in.
 * - : TRUE if the user has permission to access administration pages.
 *
 * Site identity:
 * - : The URL of the front page. Use this instead of ,
 *   when linking to the front page. This includes the language domain or
 *   prefix.
 * - : The path to the logo image, as defined in theme configuration.
 * - : The name of the site, empty when display has been disabled
 *   in theme settings.
 * - : The slogan of the site, empty when display has been disabled
 *   in theme settings.
 *
 * Navigation:
 * -  (array): An array containing the Main menu links for the
 *   site, if they have been configured.
 * -  (array): An array containing the Secondary menu links for
 *   the site, if they have been configured.
 * - : The breadcrumb trail for the current page.
 *
 * Page content (in order of occurrence in the default page.tpl.php):
 * -  (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - : The page title, for use in the actual HTML content.
 * -  (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 * - : HTML for status and error messages. Should be displayed
 *   prominently.
 * -  (array): Tabs linking to any sub-pages beneath the current page
 *   (e.g., the view and edit tabs when displaying a node).
 * -  (array): Actions local to the page, such as 'Add menu' on the
 *   menu administration interface.
 * - : A string of all feed icons for the current page.
 * - : The node object, if there is an automatically-loaded node
 *   associated with the page, and the node ID is the second argument
 *   in the page's path (e.g. node/12345 and node/12345/revisions, but not
 *   comment/reply/12345).
 *
 * Regions:
 * - ['help']: Dynamic help text, mostly for admin pages.
 * - ['highlighted']: Items for the highlighted content region.
 * - ['content']: The main content of the current page.
 * - ['sidebar_first']: Items for the first sidebar.
 * - ['sidebar_second']: Items for the second sidebar.
 * - ['header']: Items for the header region.
 * - ['footer']: Items for the footer region.
 *
 * @see bootstrap_preprocess_page()
 * @see template_preprocess()
 * @see template_preprocess_page()
 * @see bootstrap_process_page()
 * @see template_process()
 * @see html.tpl.php
 *
 * @ingroup themeable
 */
?>
<!--//End Header-->

<section class="banner d-flex align-items-center">
<div class="container">
<div class="row">
<div class="col-md-6 offset-md-6">
<h1>TAILORED <br/> PRECISION <br/>NUTRITION <br/>MISSION</h1>
<h5>To deliver excellent software features that provide tailored cardiovascular, nutrition, and resistance training programs that increase member satisfaction and facility revenue.</h5>
</div>
</div>
</div>
</section><!--//End Banner-->

<div class="create-account-strip">
<div class="container">
<div class="row rows align-items-center">
<div class="col-xl-auto columns">
<h5 class="fontWeight-black">Get started helping your client achieve their goals today</h5>
</div>
<div class="col-xl columns">
<a href="/user/register" class="create-account-btn">Start Free Trial</a>
</div>
</div>
</div>
</div><!--//End Create Account-->

<section class="program-section">
<div class="container">
<div class="row rows">

<div class="col-md-6 columns">
<div class="program">
<div class="row rows align-items-center">
<div class="col-sm-auto columns">
<div class="program-icon"><img src="/sites/all/themes/tpnperfectbodies/images/icon-1.png" alt="" class="d-block"></div>
</div>
<div class="col-sm columns">
<h6>Cardiovascular programs</h6>
<p>Cardiovascular programs for people of all ages, fitness levels, and medical conditions based on ACSM Guidelines promoting heart health and fat loss.</p>
</div>
</div>
</div>
</div>

<div class="col-md-6 columns">
<div class="program">
<div class="row rows align-items-center">
<div class="col-sm-auto columns">
<div class="program-icon"><img src="/sites/all/themes/tpnperfectbodies/images/icon-2.png" alt="" class="d-block"></div>
</div>
<div class="col-sm columns">
<h6>Nutrition programs</h6>
<p>Nutrition programs to reach exact body fat and weight goals including daily caloric intake, grams of macronutrients per day, and grams of macronutrients per meal</p>
</div>
</div>
</div>
</div>

<div class="col-md-6 columns">
<div class="program">
<div class="row rows align-items-center">
<div class="col-sm-auto columns">
<div class="program-icon"><img src="/sites/all/themes/tpnperfectbodies/images/icon-3.png" alt="" class="d-block"></div>
</div>
<div class="col-sm columns">
<h6>tailored meal plans</h6>
<p>Hundreds of tailored meal plans that meet an exact breakdown and developed in seconds. Meal plans can be edited by refreshing an item in a given meal, and you also have the ability to exclude meal items due to allergies and preferences.</p>
</div>
</div>
</div>
</div>

<div class="col-md-6 columns">
<div class="program">
<div class="row rows align-items-center">
<div class="col-sm-auto columns">
<div class="program-icon"><img src="/sites/all/themes/tpnperfectbodies/images/icon-4.png" alt="" class="d-block"></div>
</div>
<div class="col-sm columns">
<h6>Resistance training programs</h6>
<p>Resistance training programs tailored to individual needs including bodybuilding contest, muscle gain, weight loss, endurance training, cardiac rehabilitation, a custom option to develop your own training session.</p>
</div>
</div>
</div>
</div>

</div>
</div>
</section><!--//End Program Section-->

<section class="article-section">
<div class="container">
<div class="row">
<div class="col-lg-6">
<article class="article">
<figure class="d-block d-lg-none"><img src="/sites/all/themes/tpnperfectbodies/images/bg-1.jpg" alt="" class="d-block"></figure>
<h5>TPN was developed to save numerous hours of time and significantly increase revenue for facilities specializing in Improving health and quality of life for their members and clients. Tpnbodyperfect.com accomplishes this by providing individually tailored cardiovascular programs, nutrition breakdowns including hundreds of meals developed in seconds, and hundreds of resistance training options from which to choose. This revolutionary new platform can accommodate all three fitness components for the most deconditioned cardiac rehabilitation patient to the most elite athlete.</h5>
<h5>The tpnperfectbodies.com platform provides cardiovascular, nutrition, and resistance training options that include muscle gain, bodybuilding and figure contest preparation, active weight loss, general weight loss, weight maintenance as goals are reached, and custom programs which allows the user to select percentages of macronutrients desired; as well as resistance exercises with sets and repetitions determined by the user. Our platform's goal is to help design and develop comprehensive programs for clients. TPN is not necessarily telling anyone how to accomplish goals, but rather providing a tremendously valuable tool that reduces program development from hours to minutes. </h5>
<div><a href="/demo" class="btn btn-primary">LEARN MORE</a></div>
</article>
</div>
</div>
</div>
</section><!--//End Article Section-->

<section class="tpn-software-section">
<div class="tpn-software-section-header text-center">
<div class="container">
<h2>TPN  Software</h2>
<h4>what makes TPN so execptional</h4>
</div>
</div>
<div class="tpn-software-section-content">
<div class="container">
<div class="row rows">

<div class="col-lg-6 columns">
<ul>
<li><h5>Tailored programs including bodybuilding, figure, and physique competition, active weight loss, general weight loss, muscle gain, and custom designed.</h5></li>
<li><h5>Client profile with target heart rates and daily nutrition breakdown.</h5></li>
<li><h5>Safe and effective cardiovascular program for fat loss absolutely free with any program.</h5></li>
<li><h5>A maintenance meal program to keep the person at a desired weight and body fat.</h5></li>
<li><h5>Hundreds of meal plans developed in seconds.</h5></li>
</ul>
</div>

<div class="col-lg-6 columns">
<ul>
<li><h5>A program for a custom developed protocol.</h5></li>
<li><h5>Easy and fast data entry, auto updates, and extensive database.</h5></li>
<li><h5>Significant decrease in time to develop programs. Hours of meal development accomplished in minutes.</h5></li>
<li><h5>Very fast, effective, and healthy programs substantially benefitting clients,membership, and facility revenue.</h5></li>
<li><h5>A monthly expense that pays for itself with one client paying a modest price for a very effective and efficient program.</h5></li>
</ul>
</div>

</div>
</div>
</div>
</section><!--//End TPN Software Section-->

<div class="button-group">
<div class="container">
<div class="row rows justify-content-center justify-content-md-between">
<div class="col-md col-sm-8 columns">
<a href="/demo" class="button">view demo</a>
</div>
<div class="col-md col-sm-8 columns">
<a href="/programs" class="button">pricing</a>
</div>
<div class="col-md col-sm-8 columns">
<a href="/programs" class="button">PROGRAMS</a>
</div>
</div>
</div>
</div><!--//End Button Group-->


<?php print render($page['footer']); ?>
